unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SkinCaption, WinSkinData, ztvregister, ztvBase, ztvZip, ExtCtrls,
  StdCtrls, Mask, ToolEdit, Buttons, Placemnt, Wait, ExeMod, ShellAPI, MSHTMLDemoFrm;

type
  TMainForm = class(TForm)
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    Image1: TImage;
    Label1: TLabel;
    Shape1: TShape;
    Label2: TLabel;
    HTMLDir: TDirectoryEdit;
    btnAddTags: TButton;
    OpenDialog: TOpenDialog;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    TagsList: TListBox;
    Image2: TImage;
    btnAddTag: TButton;
    btnEditTag: TButton;
    btnRemoveTag: TButton;
    btnRemoveAllTags: TButton;
    Label9: TLabel;
    Label10: TLabel;
    BitBtn1: TBitBtn;
    FormStorage: TFormStorage;
    Zip: TZip;
    btnHelp: TSpeedButton;
    Label7: TLabel;
    Label8: TLabel;
    ProductName: TEdit;
    OpenDialog1: TSaveDialog;
    procedure btnAddTagsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRemoveAllTagsClick(Sender: TObject);
    procedure btnRemoveTagClick(Sender: TObject);
    procedure btnEditTagClick(Sender: TObject);
    procedure btnAddTagClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ZipTmpFileProgress(Sender: TObject; ByFile, ByArchive: Byte);
    procedure ZipProgress(Sender: TObject; ByFile, ByArchive: Byte);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnAddTagsClick(Sender: TObject);
begin
  if DirectoryExists(HTMLDir.Text) then
   OpenDialog.InitialDir := HTMLDir.Text;
  if OpenDialog.Execute then
  begin
    // edit this HTML
    with TForm1.Create(Self) do
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  HTMLDir.InitialDir := ExtractFilePath(ParamStr(0));
end;

procedure TMainForm.btnRemoveAllTagsClick(Sender: TObject);
begin
  if Application.MessageBox('Are you sure you want to remove all the tags?', 'Warning', MB_YESNO+MB_ICONQUESTION) = mrYes then
   TagsList.Items.Clear;
end;

procedure TMainForm.btnRemoveTagClick(Sender: TObject);
begin
  if TagsList.ItemIndex >= 0 then
   TagsList.Items.Delete(TagsList.ItemIndex);
end;

procedure TMainForm.btnEditTagClick(Sender: TObject);
var S: String;
begin
  if TagsList.ItemIndex < 0 then Exit;
  S := TagsList.Items[TagsList.ItemIndex];
  InputQuery('Edit Tag', 'Enter the new name for your tag:', S);
  TagsList.Items[TagsList.ItemIndex] := S;
end;

procedure TMainForm.btnAddTagClick(Sender: TObject);
var S: String;
begin
  S := '';
  InputQuery('Add Tag', 'Enter the name for your new tag:', S);
  TagsList.Items.Add(S);
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);

function Add(S: String): String;
begin
  if S<>'' then
   if S[1]='"' then
    Delete(S, 1, 1);
  if S<>'' then
   if S[Length(S)]='"' then
    Delete(S, Length(S), 1);
  if S<>'' then
   if S[Length(S)] <> '\' then
    S := S + '\';
  Result := S;
end;

var MyString, ZIPName: String;
    List: TStringList;
begin
  if TagsList.Items.Count = 0 then
  begin
    Application.MessageBox('You need to define at least one brandable tag!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  if not DirectoryExists(HTMLDir.Text) then
  begin
    Application.MessageBox('The HTML directory you selected does not exist!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  { Open dialog }
  OpenDialog1.InitialDir := OpenDialog.InitialDir;
  if OpenDialog1.Execute then
  begin

    Zip.DateAttribute := daFileDate;    // default value
    Zip.StoredDirNames := sdRelative;   // default value
    Zip.CompressMethod := cmDeflate;    // default value
    Zip.RecurseDirs := True;
    Zip.Switch := swAdd;                // default value
    Zip.StoreEmptySubDirs := True;     // default value
    Zip.EncryptHeaders := False;

    Zip.ExcludeSpec.Clear();
    Zip.FileSpec.Clear();

   // ****************************************************************
   // NOTE: for a better understanding of how the Attributes property
   // works with file attributes see demo demos\filescan\fs_demo.dpr.
   // ****************************************************************

    // See the Attributes property in the object inspector
    // Set Zip Attributes property by calling the SetAttribute method
    Zip.SetAttribute(fsZeroAttr, True); // default
    Zip.SetAttribute(fsArchive, True);  // default
    Zip.SetAttribute(fsDirectory, True); // default = False
    Zip.SetAttribute(fsHidden, True);   // default = False
    Zip.SetAttribute(fsReadOnly, True); // default
    Zip.SetAttribute(fsSysFile, True);  // default = False

    // See the AttributesEx property in teh object inspector
    // Set the AttributesEx property by calling the SetAttributeEx method.
    // Exclude none
    Zip.SetAttributeEx(fsZeroAttr, False); // default
    Zip.SetAttributeEx(fsArchive, False); // default
    Zip.SetAttributeEx(fsDirectory, False); // default
    Zip.SetAttributeEx(fsHidden, False); // default
    Zip.SetAttributeEx(fsReadOnly, False); // default
    Zip.SetAttributeEx(fsSysFile, False); // default

    Enabled := False;
    WaitForm.Timer.Enabled := True;
    WaitForm.Show;
    ZIPName := ChangeFileExt(OpenDialog1.FileName, '.zip');
    Zip.ArchiveFile := ZIPName;
    Zip.FileSpec.Add(Add(HTMLDir.Text)+'*.*');
    Zip.Compress();

    // now add this ZIP to our EXE
    CopyFile(PChar(ExtractFilePath(ParamStr(0))+'HTMLBrander.dll'), PChar(OpenDialog1.FileName), False);
    MyString := File2String(ZIPName);
    Add2File('ZIP', OpenDialog1.FileName, MyString);
    DeleteFile(ZIPName);
    // now add the tags
    List := TStringList.Create;
    List.Assign(TagsList.Items);
    List.Insert(0, ProductName.Text);
    List.SaveToFile(ExtractFilePath(ParamStr(0))+'HTMLBrander.tmp');
    List.Free;
    MyString := File2String(ExtractFilePath(ParamStr(0))+'HTMLBrander.tmp');
    Add2File('TAGS', OpenDialog1.FileName, MyString);
    DeleteFile(ExtractFilePath(ParamStr(0))+'HTMLBrander.tmp');
    // that's it!

    WaitForm.Timer.Enabled := False;
    WaitForm.Hide;
    Enabled := True;
    ShowMessage('Your website has been successfully branded!');
  end;
end;

procedure TMainForm.ZipTmpFileProgress(Sender: TObject; ByFile,
  ByArchive: Byte);
begin
  Application.ProcessMessages;
end;

procedure TMainForm.ZipProgress(Sender: TObject; ByFile, ByArchive: Byte);
begin
  Application.ProcessMessages;
end;

procedure TMainForm.btnHelpClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.htmlbrander.com', '', '', SW_SHOWNORMAL);
end;

end.
